<?php
defined('PHP168_PATH') or die();

/**
* 修改内容
**/

$this_controller->check_admin_action($ACTION) or message('no_privilege');

$this_system->init_model();
$this_model or message('no_such_cms_model');
$this_model['enabled'] or message('cms_model_disabled');

$allow_verify = $this_controller->check_admin_action('verify');
$allow_attribute = $this_controller->check_admin_action('attribute');
$allow_filter_word = $this_controller->check_admin_action('filter_word');
$allow_level = $this_controller->check_admin_action('level');
$allow_list_order = $this_controller->check_admin_action('list_order');
$allow_create_time = $this_controller->check_admin_action('create_time');
if(REQUEST_METHOD == 'GET'){
	
	$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
	$id or message('no_such_item');

	if(isset($_GET['verified'])){
		$verified = $_GET['verified'] == 1 ? true : false;
	}else{
		$verified = true;
	}

	if($verified){
		
		$select = select();
		$select->from($this_module->main_table .' AS m', 'm.*');
		$select->inner_join($this_module->table .' AS i', 'i.*', 'i.id = m.id');
		$select->inner_join($this_module->addon_table .' AS a', 'a.*, a.iid AS id', 'm.id = a.iid');
		$select->in('i.id', $id);
		$select->in('a.page', 1);
		
		$data = $core->select($select, array('single' => true, 'ms' => 'master'));
		$data or message('no_such_item');
		
	}else{
		
		$select = select();
		$select->from($this_module->unverified_table, 'verified, pages, data');
		$select->in('id', $id);
		$_data = $core->select($select, array('single' => true, 'ms' => 'master'));
		$_data or message('no_such_item');
		
		$verified = $_data['verified'];
		$pages = $_data['pages'];
		$_data = mb_unserialize($_data['data']);
		$_data['item']['create_time_release'] = $_data['create_time_release'] ? 1:0;
		$data = array_merge($_data['addon'], $_data['item'], $_data['main']);
		$data['pages'] = $pages;
		$data['verified'] = $verified;
		unset($_data);
		//print_r($_data);
	}
	//echo $select->build_sql();
	
	//检查权限
	if($data['uid'] != $UID){
		$this_controller->check_category_action('update', $data['cid']) or message($P8LANG['cms_item']['no_category_privilege']);
	}
	
	$my_addible_category = p8_json($this_controller->get_acl('my_addible_category'));
	
	
	$this_module->format_data($data);
	$data['list_order_date'] = date('Y-m-d H:i:s', $data['list_order']);
	$data['timestamp_date'] = date('Y-m-d H:i:s', $data['timestamp']);
	
	//内容属性
	$data['attributes'] = array_flip(explode(',', $data['attributes']));
	$data['summary'] = html_entity_decode($data['summary']);
	
	$config = mb_unserialize(stripslashes($data['config']));
    
    $config['allow_ip']['enabled'] = isset($config['allow_ip']['enabled']) ? $config['allow_ip']['enabled'] : 0;
	$config['allow_ip']['collectip'] = isset($config['allow_ip']['collectip']) ? $config['allow_ip']['collectip'] : array();
	$config['allow_ip']['beginip'] = isset($config['allow_ip']['beginip']) ? trim($config['allow_ip']['beginip']) : '';
	$config['allow_ip']['endip'] = isset($config['allow_ip']['endip']) ? trim($config['allow_ip']['endip']) : '';
	$config['allow_ip']['ruleoutip'] = isset($config['allow_ip']['ruleoutip']) ? $config['allow_ip']['ruleoutip'] : array();
	
	$select = select();
	$select->from($this_module->attribute_table. ' AS a', 'a.aid, a.timestamp, a.last_setter');
	$select->in('a.id', $id);
	$_attributes = $core->list_item(
		$select,
		array(
			'page' => 0
		)
	);
	$attributes = array();
	foreach($_attributes as $v){
		$attributes[$v['aid']] = $v;
	}
	unset($_attributes);
	
	$data['iid'] = $data['id'];
	$page_url = $this_router .'-update_addon?model='. $MODEL .'&iid='. $data['id'] .'&verified='. $verified .'&page=?page?';
	
	$pages = list_page(array(
		'count' => $data['pages'],
		'page' => 1,
		'page_size' => 0,
		'url' => $page_url
	));	
	$uploader_config = $core->get_config('core','uploader');
	$thumb_width = $uploader_config['thumb']['width'] ? intval($uploader_config['thumb']['width']) : 0;
	$thumb_height = $uploader_config['thumb']['height'] ? intval($uploader_config['thumb']['height']) : 0;
    $authority_enable = $this_module->CONFIG['authority'];
    if($authority_enable) $core->get_cache('role');
    $authority = $data['authority'] ? explode(",",$data['authority']) : array();
	require $this_model['path'] .'/admin/update.php';
	$template = empty($this_model['CONFIG']['admin_edit_template']) ? 'edit' : $this_model['CONFIG']['admin_edit_template'];

	include template($this_module, $template, 'admin');

}else if(REQUEST_METHOD == 'POST'){

	//如果魔法引号开启strip掉
	$_POST = p8_stripslashes2($_POST);

	$id = isset($_POST['id']) ? intval($_POST['id']) : 0;
	$id or message('no_such_item');
	//大分类不允许发布信息
	$category_module = $this_system->load_module('category');	
	$category_module->get_cache();
	if($category_module->categories[$_POST['cid']]['type'] == 1) message('category_post_rule');
	
	if(!$this_controller->check_admin_action('verify')){
		unset($_POST['verify']);
	}
	$_POST['verify'] = $this_controller->check_category_action('autoverify', $_POST['cid']) ? 1 : 0;
	$data = $this_module->data('read', $id);
	if(empty($data)){
		$data = $this_module->data_unverified($id);
		$_POST['verify'] = $data['uid'] != $UID ? 0 : $_POST['verify'];
	}
	if(isset($_POST['verified'])){
		$verified = $_POST['verified'] == 1 ? true : false;
	}else{
		$verified = true;
	}
	require $this_model['path'] .'/admin/update.php';
	$ADMIN_LOG = array('title' => $P8LANG['_module_update_admin_log']);		
	$this_controller->update($id, $_POST, $verified) or message('fail');	
	/*
	* 针对子站推送数据给总站时，当总站修改数据时，能同步修改分站相应数据
	*/
	$systems = $core->list_systems();
	if(isset($systems['sites']) && $systems['sites']['installed'] && $systems['sites']['enabled']){
		$stop_table = $core->TABLE_.'sites_stop_data';
		$new_data = $DB_master->fetch_one("select item_id,model,cid,site from $stop_table where `new_id` = $id");
		//var_dump($new_data);exit;
		if(!empty($new_data)){
			$item_id = $new_data['item_id'];		
			$sites = $core->load_system('sites');
			$sites->init_model();
			$item = $sites->load_module('item');
			$read_data = $item->data('read', $item_id);
			$_POST['cid'] = $read_data['cid'];
			$controller = $core->controller($item);	
			$sites->SITE = $new_data['site'];
			$item->set_model($new_data['model']);
			$datas = $_POST;
			$datas['verify'] = 1;
			require $this_model['path'] .'/admin/update.php';
			$controller->update($item_id, $datas, true);
		}
	}
	$data['#category'] = $this_system->fetch_category($data['cid'],true);
	$static_view_url = p8_url($this_module, $data, 'view');
	$verified = $_POST['verify'] ? true : false;
    $verified = !empty($_POST['create_time_release']) && (!empty($_POST['timestamp']) && strtotime($_POST['timestamp']) > P8_TIME)  ? 66 : ($verified ? 1 : 0);
	message(
		array(
			array('cms_to_edit', $this_module->admin_controller .'-update?id='.$id.'&model='.$_POST['model'].'&verified='.$verified),
			array('cms_to_list', $this_module->admin_controller .'-list?cid='.$_POST['cid'].'&model='.$_POST['model']),
			array('cms_to_view', $static_view_url.'?verified='. $_POST['verify'].$flag, '_blank'),
			array('cms_to_view_dynamic', $STATIC_URL.'/index.php/cms/item-view-id-'.$id .'?verified='. $_POST['verify'].$flag, '_blank'),
			array('cms_to_add', $this_module->admin_controller .'-add?cid='.$_POST['cid'].'&model='.$_POST['model'])
		),
		$this_module->admin_controller .'-add?cid='. $_POST['cid'] .'&model='. $_POST['model'],
		10000
	);

}
